clear;
clc;
//WINDOWS 10 64-BIT OS , Scilab and toolbox versions 6.1.0.
//The memory to the processor will be allocated in several blocks of memory, in order to make a perfectly organized allocation between the memory blocks and process, three different partition and allocation algorithms are used 1. First-Fit Memory Allocation  2. Best-Fit Memory Allocation 3. Worst-Fit Memory Allocation 

/* loading all the necessary functions */
exec("first_fit_func.sci");
exec("best_fit_func.sci");
exec("worst_fit_func.sci");
exec("display_func.sci");

mprintf("Memory Management First fit, Best Fit and Worst Fit Allocation\n ");
mprintf("---------------------------------------------------------------\n ");

mprintf("Ex: Process size P1=212, P2=417, P3=112, P4=426");
mprintf("\n    Block or hole size B1= 100, B2= 500, B3=200, B4=300, B5=600\n");

/* Example problem */ 
p = [212,417,112,426];// process size
b = [100,500,200,300,600];// block or hole size

disp("Select the Option:");
mprintf(" 1-First Fit\n"); 
mprintf(" 2-Best Fit \n")
mprintf(" 3-Worst Fit \n");

/*
Determining the number of processes and blocks
*/
size_process = size(p);
size_process = size_process(2);

size_block = size(b);
size_block = size_block(2);

n1=input("");
if(n1==1) then
//    firstfit();
/*calling the function, defined in first fit.sci, for first fit allocation*/
    ff_allot = firstFit(p,b,size_process,size_block)
end
if(n1==2) then
/*calling the function, defined in best fit.sci, for best fit allocation*/
    bf_allot = bestFit(p, b, size_process, size_block)

end
if(n1==3) then
//    worstfit();
/*calling the function, defined in worst fit.sci, for worst fit allocation*/
wf_allot = worstFit(p,b,size_process,size_block);

end

/*
ff_allotsize - size of the selected blocks for first fit
bf_allotsize - size of the selected blocks for best fit
wf_allotsize - size of the selected blocks for worst fit
*/
ff_allotsize = zeros(1,size_process);
bf_allotsize = zeros(1,size_process);
wf_allotsize = zeros(1,size_process);

/* storing the allocated block size for each process according to the respective fits */
for i=1:size_process
    if(n1==1) then
    
        if ff_allot(i)~=0 then // checking if any block is selected
            ff_allotsize(i) = b(ff_allot(i)); // storing the size of the selected block for first fit
        else
            ff_allotsize(i) = 0 // store size as 0 if no block is selected
        end,
    end 
       
    if(n1==2) then
        if bf_allot(i)~=0 then // checking if any block is selected
            bf_allotsize(i) = b(bf_allot(i)); // storing the size of the selected block for best fit
        else
            bf_allotsize(i) = 0 // store size as 0 if no block is selected
        end, 
    end
    if(n1==3) then
        if wf_allot(i)~=0 then // checking if any block is selected
            wf_allotsize(i) = b(wf_allot(i)); // storing the size of the selected block for worst fit
        else
            wf_allotsize(i) = 0; // store size as 0 if no block is selected
        end,
    end
end
/*
printing first fit, best fit and worst fit array
*/
if(n1==1) then
mprintf("\nFIRST FIT:\n")
mprintf("Process no. \tProcess size\tBlock no. Block size\n")
    display(ff_allot,ff_allotsize,size_process,p)
end
if(n1==2) then

    mprintf("\nBEST FIT:\n")
    mprintf("Process no. \tProcess size\tBlock no. Block size\n")
    display(bf_allot,bf_allotsize,size_process,p)
end
if(n1==3) then

    mprintf("\nWORST FIT:\n")
    mprintf("Process no. \tProcess size\tBlock no. Block size\n")
    display(wf_allot,wf_allotsize,size_process,p)
end
